jQuery(function($) {
    var sqm_price = 0;
    var currency = '€';
    var base_text = '';
    if (typeof wdd_vars !== 'undefined') {
        sqm_price = parseFloat(wdd_vars.sqm_price) || 0;
        currency = wdd_vars.currency_symbol || currency;
        base_text = wdd_vars.price_per_sqm_text || '';
    }

    function formatPrice(num) {
        return num.toFixed(2) + ' ' + currency;
    }

    function showBasePrice() {
        var $price = $('.summary .price').first();
        if ($price.length && base_text) {
            $price.html('<span class="woocommerce-Price-amount amount">' + base_text + '</span>');
        }
    }

    function updatePrice() {
        var w = ($('#wdd_width').val() || '').toString().replace(',', '.');
        var h = ($('#wdd_height').val() || '').toString().replace(',', '.');
        var width_cm = parseFloat(w) || 0;
        var height_cm = parseFloat(h) || 0;

        var width = width_cm / 100;
        var height = height_cm / 100;
        var sqm = width * height;

        if (sqm > 0) {
            $('#wdd_area').text('Fläche: ' + sqm.toFixed(2) + ' m²');

            var total = sqm * sqm_price;
            if (total > 0) {
                var $price = $('.summary .price').first();
                if ($price.length) {
                    $price.html('<span class="woocommerce-Price-amount amount">' + formatPrice(total) + '</span>');
                }
            }
        } else {
            $('#wdd_area').text('');
            showBasePrice();
        }
    }

    // Beim Laden Grundpreis anzeigen
    showBasePrice();

    // Live-Aktualisierung bei Eingabe
    $('#wdd_width, #wdd_height').on('input', updatePrice);
});
