<?php
/**
 * Plugin Name: WooCommerce Preis auf Anfrage
 * Description: Ersetzt Preis und Warenkorb-Button durch "Preis auf Anfrage" und einen Kontaktlink, wenn im Produkt aktiviert.
 * Version: 2.1
 * Author: Dateck-Media
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Feld im Produkt-Backend hinzufügen (Checkbox)
 */
add_action( 'woocommerce_product_options_general_product_data', function() {
    woocommerce_wp_checkbox( array(
        'id'          => '_price_on_request',
        'label'       => 'Preis auf Anfrage',
        'description' => 'Preis und Warenkorb-Button durch Kontaktlink ersetzen.',
    ) );
});

/**
 * Feld speichern
 */
add_action( 'woocommerce_process_product_meta', function( $post_id ) {
    $value = isset( $_POST['_price_on_request'] ) ? 'yes' : 'no';
    update_post_meta( $post_id, '_price_on_request', $value );
});

/**
 * Preis ersetzen
 */
add_filter( 'woocommerce_get_price_html', function( $price, $product ) {
    if ( 'yes' === get_post_meta( $product->get_id(), '_price_on_request', true ) ) {
        return '<span class="price-anfrage">Preis auf Anfrage</span>';
    }
    return $price;
}, 9999, 2 );

/**
 * Produkt nicht kaufbar machen → entfernt Warenkorb & Mengenfeld
 */
add_filter( 'woocommerce_is_purchasable', function( $purchasable, $product ) {
    if ( 'yes' === get_post_meta( $product->get_id(), '_price_on_request', true ) ) {
        return false;
    }
    return $purchasable;
}, 10, 2 );

/**
 * Button auf Einzelprodukt-Seite einfügen
 */
add_action( 'woocommerce_single_product_summary', function() {
    global $product;
    if ( $product && 'yes' === get_post_meta( $product->get_id(), '_price_on_request', true ) ) {
        $url = get_option( 'wc_price_request_url', site_url('/kontakt/') );
        echo '<a href="' . esc_url( $url ) . '" class="button kontakt-button">Zum Kontaktformular</a>';
    }
}, 31 );

/**
 * Button auf Shop-Seiten ersetzen
 */
add_filter( 'woocommerce_loop_add_to_cart_link', function( $button, $product ) {
    if ( 'yes' === get_post_meta( $product->get_id(), '_price_on_request', true ) ) {
        $url = get_option( 'wc_price_request_url', site_url('/kontakt/') );
        return '<a href="' . esc_url( $url ) . '" class="button kontakt-button">Zum Kontaktformular</a>';
    }
    return $button;
}, 10, 2 );

/**
 * Eigene Einstellung in WooCommerce → Produkte einfügen
 */
add_filter( 'woocommerce_get_settings_products', function( $settings, $current_section ) {
    // Nur im Hauptbereich "Produkte" (kein Untertab)
    if ( '' === $current_section ) {
        $settings[] = array(
            'title' => 'Preis auf Anfrage',
            'type'  => 'title',
            'id'    => 'wc_price_request_options',
        );

        $settings[] = array(
            'title'    => 'Kontaktformular-URL',
            'desc'     => 'Die Seite, zu der der "Zum Kontaktformular"-Button führt.',
            'id'       => 'wc_price_request_url',
            'type'     => 'text',
            'default'  => site_url('/kontakt/'),
            'desc_tip' => true,
        );

        $settings[] = array(
            'type' => 'sectionend',
            'id'   => 'wc_price_request_options',
        );
    }

    return $settings;
}, 10, 2 );
